
return function (stream, name)
	if name == "OAUTHBEARER" and stream.username then
		return function (stream)
			local auth = stream.bearer_token and ("Bearer "..stream.bearer_token) or "";
			local message, data = coroutine.yield("n,a="..stream.username.."@"..stream.host..",\001auth="..auth.."\001");
			if message == "success" then
				return true;
			elseif message == "challenge" then
				stream:event("oauth-failure", {
					json = data;
				});
				-- Note: No code after the yield should generally execute, as "failure"
				-- doesn't get passed through to us (it contains no data anyway)
				if coroutine.yield("\001") ~= "failure" then
					error("Unexpected SASL state: expected failure after challenge");
				end
				return false;
			end
		end, stream.bearer_token and 6 or 4; -- Prefer OAUTHBEARER if we have a token, otherwise prefer password if we have one
	end
end
