local verse = require "verse";
local dt = require "util.datetime";

local xmlns_time = "urn:xmpp:time";

function verse.plugins.time(stream)
	function stream:query_time(target_jid, callback)
		callback = callback or function (time) return self:event("time/response", time); end
		self:send_iq(verse.iq({ type = "get", to = target_jid })
			:tag("time", { xmlns = xmlns_time }),
			function (reply)
				if reply.attr.type == "result" then
					local query = reply:get_child("time", xmlns_time);
					local resp = {
						tzo = query:get_child_text("tzo");
						utc = query:get_child_text("utc");
					};
					if resp.utc then
						resp.timestamp = dt.parse(resp.utc);
					end
					callback(resp);
				else
					local type, condition, text = reply:get_error();
					callback({
						error = true;
						condition = condition;
						text = text;
						type = type;
					});
				end
			end);
	end
	return true;
end
