-- Import gettime() from LuaSocket, as a way to access high-resolution time
-- in a platform-independent way

local socket_gettime = require "socket".gettime;

local monotonic;

local have_system_lib, system = pcall(require, "system");
if have_system_lib then
	monotonic = system.monotime;
end

return {
	now = socket_gettime;
	monotonic = monotonic;
}
