
local jid_bare = require "util.jid".bare;
local jid_split = require "util.jid".split;
local st = require "util.stanza";
local hosts = hosts;
local user_exists = require "core.usermanager".user_exists;
local is_contact_subscribed = require "core.rostermanager".is_contact_subscribed;
local pairs, ipairs = pairs, ipairs;
local next = next;
local load_roster = require "core.rostermanager".load_roster;

local NULL = {};
local data = {};
local recipients = {};

module:add_identity("pubsub", "pep");
module:add_feature("http://jabber.org/protocol/pubsub#publish");

local function publish(session, node, item)
	local disable = #item.tags ~= 1 or #item.tags[1].tags == 0;
	local bare = session.username..'@'..session.host;
	local stanza = st.message({from=bare, type='headline'})
		:tag('event', {xmlns='http://jabber.org/protocol/pubsub#event'})
			:tag('items', {node=node})
				:add_child(item)
			:up()
		:up();

	-- store for the future
	local user_data = data[bare];
	if disable then
		if user_data then user_data[node] = nil; end
		if not next(user_data) then data[bare] = nil; end
	else
		if not user_data then user_data = {}; data[bare] = user_data; end
		user_data[node] = stanza;
	end
	
	-- broadcast
	for recipient in pairs(recipients[user] or NULL) do
		stanza.attr.to = recipient;
		core_post_stanza(session, stanza);
	end
end

local function get_caps_hash_from_presence(stanza, current)
	local t = stanza.attr.type;
	if not t then
		for _, child in pairs(stanza.tags) do
			if child.name == "c" and child.attr.xmlns == "http://jabber.org/protocol/caps" then
				local attr = child.attr;
				if attr.hash then -- new caps
					if attr.hash == 'sha-1' and attr.node and attr.ver then return attr.ver, attr.node.."#"..attr.ver; end
				else -- legacy caps
					if attr.node and attr.ver then return attr.node.."#"..attr.ver.."#"..(attr.ext or ""), attr.node.."#"..attr.ver; end
				end
				return; -- bad caps format
			end
		end
	elseif t == "unavailable" or t == "error" then
		return;
	end
	return current; -- no caps, could mean caps optimization, so return current
end

module:hook("presence/bare", function(event)
	-- inbound presence to bare JID recieved
	local origin, stanza = event.origin, event.stanza;
	
	local user = stanza.attr.to or (origin.username..'@'..origin.host);
	local bare = jid_bare(stanza.attr.from);
	local item = load_roster(jid_split(user))[bare];
	if not stanza.attr.to or (item and (item.subscription == 'from' or item.subscription == 'both')) then
		local recipient = stanza.attr.from;
		local current = recipients[user] and recipients[user][recipient];
		local hash = get_caps_hash_from_presence(stanza, current);
		if current == hash then return; end
		if not hash then
			if recipients[user] then recipients[user][recipient] = nil; end
		else
			recipients[user] = recipients[user] or {};
			recipients[user][recipient] = hash;
			for node, message in pairs(data[user] or NULL) do
				message.attr.to = stanza.attr.from;
				origin.send(message);
			end
		end
	end
end, 10);

module:hook("iq/bare/http://jabber.org/protocol/pubsub:pubsub", function(event)
	local session, stanza = event.origin, event.stanza;
	if stanza.attr.type == 'set' and (not stanza.attr.to or jid_bare(stanza.attr.from) == stanza.attr.to) then
		local payload = stanza.tags[1];
		if payload.name == 'pubsub' then -- <pubsub xmlns='http://jabber.org/protocol/pubsub'>
			payload = payload.tags[1];
			if payload and payload.name == 'publish' and payload.attr.node then -- <publish node='http://jabber.org/protocol/tune'>
				local node = payload.attr.node;
				payload = payload.tags[1];
				if payload then -- <item>
					publish(session, node, payload);
					return true;
				end
			end
		end
	end
end);

module:hook("iq/bare/disco", function(event)
	local session, stanza = event.origin, event.stanza;
	if stanza.attr.type == "result" then
		local disco = stanza.tags[1];
		if disco and disco.name == "query" and disco.attr.xmlns == "http://jabber.org/protocol/disco#info" then
			-- Process disco response
			-- TODO check if waiting for recipient's response
			local hash; -- TODO calculate hash
			-- TODO update hash map
			-- TODO set recipient's data to calculated data
		end
	end
end);
