---
labels:
- 'Stage-Alpha'
summary: 'Enable create invitations via the web'
...

Introduction
============

This module allows users to create new invites from the server's website.
It is quite handy when you don't have a phone with you but still want to
invite the person in front of you to chat.

Details
=======

The invitation will create account-and-contact invites (the "add to roster"
kind of invite). Once user have sucessfully enter their credential, the module
redirect them to the invite page.

It depends on these module and their purpose:

- [mod_http]: for obvious reason :).
- [mod_invites][doc:modules:mod_invites]: generate the actual invite.
- [mod_invites_register_web][doc:modules:mod_invites_register]: serve the
  invite page.

Configuration
=============

The configuration utilizes the same `allow_user_invites` and
`allow_contact_invites` as [mod_invites_adhoc]. 

If you specify a `site_name`, it will uses that else it will fallback to the
`VirtualHost` that it was loaded onto.

After successfully enabling this module, it should be available via the default
URL:

```lua
    https://prosody.example.tld/webgen
```

HTML templates can be overridden by using `invites_register_template_path`,
see the `html/` directory in the sources for the files needed.

Names of the files MUST match the default. More over, you can offer multiple
(human) languages by adding the `&l=` to the URL. Meaning this module will
serve `webgen.html` for your default URL:

```lua
    https://prosody.example.net/webgen?t=aowiefjoaij
``` 

And the `webgen.en.html` in the directory you have specified in
your config file, it will be served at:

```lua
    https://prosody.example.net/webgen?t=aowiefjoaij&l=en
```

So in your `webgen.html`, you can point to the English version by using an
`<a>` tag like this:

```lua
    <a href="/webgen?t={token}&l=en">English</a>
```

You can modify the URL in your config under `http_path` with `invites_webgen`:

```lua
http_path = {
    invites_webgen = "/registration"
}
```

