---
labels:
- 'Stage-Stable'
summary: Display your online status in web pages
rockspec:
  build:
    copy_directories:
    - icons
...

Introduction
============

Quite often you may want to publish your Jabber status to your blog or
website. mod\_webpresence allows you to do exactly this via adhoc control.

Installation
============

Copy mod\_webpresence.lua to your modules directory then add it to your
modules\_enabled list:

```

    modules_enabled = {
        "webpresence";
    };

```

Configuration & Usage
=====================

There is a set of icons supplied with the module. But you can configure it to
load your own in the config file:

```

    webpresence_icons = "/path/to/your/icons";    

```

Beware that the icon files must have the same names as the default files.

This module will always returns offline until you enable it via adhoc.

You can embed the icon into a page using a simple `<img>` tag, as follows:

    <img src="http://prosody.example.com:5280/status/john.smith@domain.net" />

Alternatively, it can be used to get status name as plain text, status message
as plain text or html-code for embedding on web-pages.

To get status name in plain text you can use something like this link:
`http://prosody.example.com:5280/status/john.smith@domain.net/text`

To get status message as plain text you can use something like following
link: `http://prosody.example.com:5280/status/john.smith@domain.net/message`

To get html code, containing status name, status image and status message
(if set): `http://prosody.example.com:5280/status/john.smith@domain.net/html`

Compatibility
=============

  -----     -------
  trunk     Works
  0.12.3    Works
  0.10      Works
  0.9       Works
  0.8       Works
  0.7       Works
  0.6       Works
  -----     -------

Todo
====

-   Display PEP information (maybe a new plugin?)
-   Internal/external image generator (GD, ImageMagick)
-   Display the correct boolean in the first form.
