-- mod_candy.lua
-- Copyright (C) 2013-2017 Kim Alvefur

local json_encode = require"util.json".encode;
local is_module_loaded = require "core.modulemanager".is_loaded;

local serve = module:depends"http_files".serve;

module:provides("http", {
	route = {
		["GET /prosody.js"] = function(event)
			event.response.headers.content_type = "text/javascript";
			local connect_path;
			if is_module_loaded(module.host, "websocket") then
				connect_path = module:http_url("websocket", "xmpp-websocket"):gsub("^http", "ws");
			else
				if not is_module_loaded(module.host, "bosh") then
					module:depends("bosh");
				end
				connect_path = module:http_url("bosh", "/http-bind");
			end

			return ("// Generated by Prosody\n"
				.."var Prosody = %s;\n")
					:format(json_encode({
						connect_path = connect_path;
						version = prosody.version;
						host = module:get_host();
						anonymous = module:get_option_string("authentication") == "anonymous";
					}));
		end;
		["GET /*"] = serve(module:get_directory().."/www_files");
		GET = function(event)
			event.response.headers.location = event.request.path.."/";
			return 301;
		end;
	}
});

