module:set_global();

local server = require "prosody.net.server";
local async = require "prosody.util.async";
local connect = require"prosody.net.connect".connect;
local basic = require "prosody.net.resolvers.basic";

local sessions = {};

local listeners = {};

function listeners.onconnect(conn)
	local event = sessions[conn];
	local response = event.response;
	response.status_code = 200;
	response:send("");
	response.conn:onwritable();
	response.conn:setlistener(listeners, event);
	server.link(conn, response.conn);
	server.link(response.conn, conn);
	response.conn = nil;
end

function listeners.onattach(conn, event)
	sessions[conn] = event;
end

function listeners.onfail(event, err)
	local response = event.response;
	if assert(response) then
		response.status_code = 500;
		response:send(err);
	end
end

function listeners.ondisconnect(conn, err)
end

module:depends("http");
module:provides("http", {
	default_path = "/";
	route = {
		["CONNECT /*"] = function(event)
			local request = event.request;
			local host, port = request.url.scheme, request.url.path;
			if port == "" then return 400 end
			-- TODO proxy-auth here, presumably same as stun/turn?
			local resolve = basic.new(host, port);
			connect(resolve, listeners, nil, event)
			return true;
		end;
	}
});
