---
labels:
- 'Stage-Merged'
summary: 'Allow account registration using invite tokens'
...

Introduction
============

::: {.alert .alert-info}
This module has been merged into Prosody as
[mod_invites_register][doc:modules:mod_invites_register]. Users of
Prosody **0.12** and later should not install this version.
:::

This module is part of the suite of modules that implement invite-based
account registration for Prosody. The other modules are:

- [mod_invites][doc:modules:mod_invites]
- [mod_invites_adhoc][doc:modules:mod_invites_adhoc]
- [mod_invites_page]
- [mod_invites_register_web]
- [mod_invites_api]
- [mod_register_apps]

For details and a full overview, start with the [mod_invites] documentation.

Details
=======

This module allows clients to register an account using an invite ('preauth')
token generated by mod_invites. It implements the protocol described at
[docs.modernxmpp.org/client/invites](https://docs.modernxmpp.org/client/invites)
and [XEP-0401 version 0.3.0](https://xmpp.org/extensions/attic/xep-0401-0.3.0.html).

**Note to developers:** the XEP-0401 protocol is expected to change in the future,
though Prosody will attempt to maintain backwards compatibility with the 0.3.0 protocol
for as long as necessary.

This module is also responsible for implementing the optional server-side part
of [XEP-0379: Pre-Authenticated Roster Subscriptions](https://xmpp.org/extensions/xep-0379.html).

**Note to admins:** Loading this module will disable registration for users
without an invite token by default. Control this behaviour 

# Configuration

| Name                     | Description                                              | Default |
|--------------------------|----------------------------------------------------------|---------|
| registration_invite_only | Require an invitation token for all account registration | `true`  |

## Example: Invite-only registration

This setup enables registration **only** for users that have a valid
invite token.

``` {.lua}
allow_registration = true
registration_invite_only = true
```

## Example: Open registration

This setup allows completely **open registration**, even without
an invite token.

``` {.lua}
allow_registration = true
registration_invite_only = false
```
